## 3. 1. 2000 je pondelok

pocet_dni = (31,28,31,30,31,30,31,31,30,31,30,31)
den = ('pondelok', 'utorok', 'streda', 'štvrtok', 'piatok', 'sobota', \
       'nedeľa')

def priestupny(rok):
    return (rok % 4 == 0) and (rok % 100 != 0) \
           or (rok % 400 == 0)

def platny(datum):
    den, mesiac, rok = datum
    return 1 <= mesiac <= 12 \
           and 1 <= den <= pocet_dni[mesiac - 1] \
           or (den, mesiac) == (29, 2) and priestupny(rok)

def dni_v_roku(rok):
    return 366 if priestupny(rok) else 365

def poradove_cislo(datum):
    den, mesiac, rok = datum
    return sum(pocet_dni[:mesiac-1]) + \
           den + \
           (1 if priestupny(rok) and (mesiac > 2) else 0)

def zajtra(datum):
    (den, mesiac, rok) = datum
    return (den + 1, mesiac, rok) if den < pocet_dni[mesiac - 1] \
                                     or den == 28 and priestupny(rok) else \
           (1,1,rok + 1) if (den, mesiac) == (31, 12) else \
           (1, mesiac + 1, rok) 

def vcera(datum):
    (den, mesiac, rok) = datum
    return (den - 1, mesiac, rok) if den > 1 else \
           (29, 2, rok) if mesiac == 3 and priestupny(rok) else \
           (31, 12, rok - 1) if (den, mesiac) == (1, 1) else \
           (pocet_dni[mesiac - 2], mesiac - 1, rok)

def plus_cyk(datum, pocet_dni):
    vysledok = datum
    for i in range(pocet_dni):
        vysledok = zajtra(vysledok)
    return vysledok

def plus_rek(datum, pocet_dni):
    return plus_rek(zajtra(datum), pocet_dni - 1) if pocet_dni > 0 \
           else datum

def minus_cyk(datum, pocet_dni):
    vysledok = datum
    for i in range(pocet_dni):
        vysledok = vcera(vysledok)
    return vysledok

def minus_rek(datum, pocet_dni):
    return minus_rek(vcera(datum), pocet_dni - 1) if pocet_dni > 0 \
           else datum

def rozdiel_rokov(rok1,rok2):
    if rok1 > rok2: rok1, rok2 = rok2, rok1
    return sum([dni_v_roku(r) for r in range(rok1, rok2)])

def mensi(datum1, datum2):
    return datum1[::-1] < datum2[::-1]

def rozdiel_datumov(datum1, datum2):
    if mensi(datum2, datum1): datum1, datum2 = datum2, datum1
    return rozdiel_rokov(datum1[2], datum2[2]) \
           - poradove_cislo(datum1) \
           + poradove_cislo(datum2)

def den_v_tyzdni(datum):
    return den[rozdiel_datumov((3,1,2000),datum) \
               * ((-1) if mensi(datum,(3,1,2000)) else 1) \
               % 7]

